package gov.va.med.mhv.mrp.data.model;

import java.io.Serializable;
import javax.persistence.*;
import java.util.Calendar;

@Entity
@Table(name="MYGOALS_TASK_ACTIVITIES")
@NamedQuery(name="MyGoalsTaskActivities.findAll", query="SELECT m FROM MyGoalsTaskActivities m")
public class MyGoalsTaskActivities implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name="TASK_ACTIVITY_ID")
	private Long taskActivityId;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="ACTIVITY_DATE")
	private Calendar activityDate;

	@Version
	private Integer oplock;

	@Column(name="TASK_REPETITION_CYCLE_TYPE")
	private Integer taskRepetitionCycleType;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="UPDATED_TIME")
	private Calendar updatedTime;

	//bi-directional many-to-one association to MyGoalsTasks
	@ManyToOne
	@JoinColumn(name="TASK_ID")
	private MyGoalsTasks myGoalsTask;

	public MyGoalsTaskActivities() {
	}

	public Long getTaskActivityId() {
		return this.taskActivityId;
	}

	public void setTaskActivityId(Long taskActivityId) {
		this.taskActivityId = taskActivityId;
	}

	public Calendar getActivityDate() {
		return this.activityDate;
	}

	public void setActivityDate(Calendar activityDate) {
		this.activityDate = activityDate;
	}

	public Integer getOplock() {
		return this.oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Integer getTaskRepetitionCycleType() {
		return this.taskRepetitionCycleType;
	}

	public void setTaskRepetitionCycleType(Integer taskRepetitionCycleType) {
		this.taskRepetitionCycleType = taskRepetitionCycleType;
	}

	public Calendar getUpdatedTime() {
		return this.updatedTime;
	}

	public void setUpdatedTime(Calendar updatedTime) {
		this.updatedTime = updatedTime;
	}

	public MyGoalsTasks getMyGoalsTask() {
		return this.myGoalsTask;
	}

	public void setMyGoalsTask(MyGoalsTasks myGoalsTask) {
		this.myGoalsTask = myGoalsTask;
	}

}